<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class FineTune extends Model
{
    use HasFactory;

    protected $table = "fine_tunes";
    protected $fillable = [
        "user_id",
        "title",
        "model_engine",
        "ft_model_id",
        "file_model_id",
        "active_status",
        "status",
        "status_details",
        "file_upload_response",
        "fine_tune_job_response",
        "deleted_at"
    ];

    protected static function boot()
    {
        parent::boot(); // TODO: Change the autogenerated stub
        static::creating(function ($model) {
            $model->user_id = userId();
        });
    }

    public function scopeModelEngine($query, $model_engine)
    {
        $query->where("model_engine", $model_engine);
    }

    public function scopeFtModeId($query, $ft_model_id)
    {
        $query->where("ft_model_id", $ft_model_id);
    }

    public function scopeUserId($query, $user_id = null)
    {
        $user_id = $user_id ?? userId();

        $query->where("user_id", $user_id);
    }

    public function user() : BelongsTo
    {

        return $this->belongsTo(User::class);
    }

    public function histories() : HasMany
    {
        return $this->hasMany(FineTuneHistory::class, "fine_tune_id");
    }

}
