<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class PdfChat extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = "pdf_chats";
    protected $fillable = [
        "chat_code",
        "prompt_tokens",
        "total_tokens",
        "total_words",
        "user_id"
    ];

    protected static function boot()
    {
        parent::boot(); // TODO: Change the autogenerated stub
        static::creating(function ($model) {
            $model->user_id   = userId();
        });
    }

    /**
     * Scopes
     * */
    public function scopeUserId($query, $user_id = null)
    {
        $user_id = empty($user_id) ? userId() : $user_id;
        $query->where('user_id', $user_id);
    }

    public function scopeChatCode($query, $chatCode)
    {
        $query->where('chat_code', $chatCode);
    }


    public function conversations($limit = 3) : HasMany
    {
        $query =  $this->hasMany(PdfChatConversation::class);

        return !empty($limi) ? $query->take(3) : $query;
    }
}
