<?php

namespace App\Services;

use App\Models\AiBlogWizard;
use App\Models\AiChatCategory;
use App\Models\Blog;
use App\Models\BlogCategory;
use App\Models\BlogTag;
use App\Models\Faq;
use App\Models\OfflinePaymentMethod;
use App\Models\PaymentGateway;
use App\Models\SubscriptionPackage;
use App\Models\Tag;

class WriteBotService
{

    public function getFaqs()
    {

        return Faq::query()->latest()->get();
    }


    public function getSubscriptionPackages($isActive = null)
    {
        $query = SubscriptionPackage::query();

        (!empty($isActive) ? $query->isActive() : null);

        return $query->get();
    }


    public function getOfflinePaymentMethods($isActive = 1)
    {
       return OfflinePaymentMethod::query()->where('is_active', $isActive)->get();
    }

    public function getPaymentGateways($isActive = 1)
    {
       return  PaymentGateway::where('is_active', $isActive)->get(['gateway', 'id', 'image']);
    }

    public function getAllBlogs($isActive = true, $paginateOrGet = true)
    {
        $query = Blog::query()->latest()->filters();

        ($isActive ? $query->isActive() : null);

        return $paginateOrGet ? $query->paginate(paginationNumber()) : $query->get();
    }

    public function getBlogCategories()
    {
        return BlogCategory::query()->get();
    }

    public function getTags()
    {
        return Tag::query()->latest()->get();
    }


    public function publishToBlog(object $aiBlogWizard, array $payloads)
    {

        $blog_category_id = $payloads["blog_category_id"];

        $aiBlogWizardArticle = $aiBlogWizard->aiBlogWizardArticle;

        $data = [
            "blog_category_id"  => $blog_category_id,
            "title"             => $aiBlogWizardArticle->title,
            "slug"              => convertToSlug($aiBlogWizardArticle->title),
            "short_description" => $aiBlogWizardArticle->outlines,
            "description"       => $aiBlogWizardArticle->value,
            "thumbnail_image"   => !empty($aiBlogWizardArticle->image) ? $aiBlogWizardArticle->image :  null,
            "is_active"         => 1,
            "is_wizard_blog"    => 1
        ];

       $blog = Blog::query()->create($data);

       // Blog Tags
        foreach($payloads["tag_id"] as $tag_id){
            BlogTag::query()->create([
                "blog_id" => $blog->id,
                "tag_id"  => $tag_id
            ]);
        }

        return $blog;
    }

    public function getAiBlogWizardById($id)
    {
        return AiBlogWizard::query()->with([
            "aiBlogWizardArticle",
            "aiBlogWizardKeyword",
        ])
        ->where('user_id', userId())
        ->latest()
        ->findOrFail($id);
    }


    public function getAiChatCategories(
        $isPluckOrGetData = null,
        $onlyActive = null,
        $conditions = []
    )
    {
        $query = AiChatCategory::query()->latest();

        if(!empty($onlyActive)){
            $query->where("is_active", $onlyActive);
        }
        if(!empty($conditions)){
            $query->where($conditions);
        }
        if (is_null($isPluckOrGetData)){
            return $query->pluck("id"); // Later pass title
        }
      
        return $isPluckOrGetData ? $query->get() : $query->get();
    }
}
