<?php

namespace Database\Seeders;

use App\Models\VoiceLanguage;
use App\Traits\Language;
use Illuminate\Database\Seeder;

class VoiceLanguageSeeder extends Seeder
{
    use Language;
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $languages = [
            ['id' => 1, 'name' => 'Afrikaans (South Africa)', 'code' => 'af-ZA', 'flag' => '/img/flags/za.svg'],
            ['id' => 2, 'name' => 'Arabic', 'code' => 'ar-XA', 'flag' => '/img/flags/ae.svg'],
            ['id' => 3, 'name' => 'Arabic (Egypt)', 'code' => 'ar-EG', 'flag' => '/img/flags/eg.svg'],
            ['id' => 4, 'name' => 'Arabic (Saudi Arabia)', 'code' => 'ar-SA', 'flag' => '/img/flags/sa.svg'],
            ['id' => 5, 'name' => 'Bengali (India)', 'code' => 'bn-IN', 'flag' => '/img/flags/in.svg'],
            ['id' => 6, 'name' => 'Bulgarian (Bulgaria)', 'code' => 'bg-BG', 'flag' => '/img/flags/bg.svg'],
            ['id' => 7, 'name' => 'Catalan (Spain)', 'code' => 'ca-ES', 'flag' => '/img/flags/es.svg'],
            ['id' => 8, 'name' => 'Chinese (Cantonese)', 'code' => 'zh-HK', 'flag' => '/img/flags/cn.svg'],
            ['id' => 9, 'name' => 'Chinese (Mandarin)', 'code' => 'cmn-CN', 'flag' => '/img/flags/cn.svg'],
            ['id' => 10, 'name' => 'Chinese (M. Simplified)', 'code' => 'zh-CN', 'flag' => '/img/flags/cn.svg'],
            ['id' => 12, 'name' => 'Chinese (Taiwanese M.)', 'code' => 'zh-TW', 'flag' => '/img/flags/cn.svg'],
            ['id' => 13, 'name' => 'Croatian (Croatia)', 'code' => 'hr-HR', 'flag' => '/img/flags/hr.svg'],
            ['id' => 14, 'name' => 'Czech (Czech Republic)', 'code' => 'cs-CZ', 'flag' => '/img/flags/cz.svg'],
            ['id' => 15, 'name' => 'Danish (Denmark)', 'code' => 'da-DK', 'flag' => '/img/flags/dk.svg'],
            ['id' => 16, 'name' => 'Dutch (Belgium)', 'code' => 'nl-BE', 'flag' => '/img/flags/be.svg'],
            ['id' => 17, 'name' => 'Dutch (Netherlands)', 'code' => 'nl-NL', 'flag' => '/img/flags/nl.svg'],
            ['id' => 18, 'name' => 'English (Australia)', 'code' => 'en-AU', 'flag' => '/img/flags/au.svg'],
            ['id' => 19, 'name' => 'English (Canada)', 'code' => 'en-CA', 'flag' => '/img/flags/ca.svg'],
            ['id' => 20, 'name' => 'English (Hongkong)', 'code' => 'en-HK', 'flag' => '/img/flags/hk.svg'],
            ['id' => 21, 'name' => 'English (India)', 'code' => 'en-IN', 'flag' => '/img/flags/in.svg'],
            ['id' => 22, 'name' => 'English (Ireland)', 'code' => 'en-IE', 'flag' => '/img/flags/ie.svg'],
            ['id' => 23, 'name' => 'English (New Zealand)', 'code' => 'en-NZ', 'flag' => '/img/flags/nz.svg'],
            ['id' => 24, 'name' => 'English (Philippines)', 'code' => 'en-PH', 'flag' => '/img/flags/ph.svg'],
            ['id' => 25, 'name' => 'English (Singapore)', 'code' => 'en-SG', 'flag' => '/img/flags/sg.svg'],
            ['id' => 26, 'name' => 'English (South Africa)', 'code' => 'en-ZA', 'flag' => '/img/flags/za.svg'],
            ['id' => 27, 'name' => 'English (UK)', 'code' => 'en-GB', 'flag' => '/img/flags/gb.svg'],
            ['id' => 28, 'name' => 'English (USA)', 'code' => 'en-US', 'flag' => '/img/flags/us.svg'],
            ['id' => 30, 'name' => 'Estonian (Estonia)', 'code' => 'et-EE', 'flag' => '/img/flags/ee.svg'],
            ['id' => 31, 'name' => 'Filipino (Philippines)', 'code' => 'fil-PH', 'flag' => '/img/flags/ph.svg'],
            ['id' => 32, 'name' => 'Finnish (Finland)', 'code' => 'fi-FI', 'flag' => '/img/flags/fi.svg'],
            ['id' => 33, 'name' => 'French (Belgium)', 'code' => 'fr-BE', 'flag' => '/img/flags/be.svg'],
            ['id' => 34, 'name' => 'French (France)', 'code' => 'fr-FR', 'flag' => '/img/flags/fr.svg'],
            ['id' => 35, 'name' => 'French (Canada)', 'code' => 'fr-CA', 'flag' => '/img/flags/ca.svg'],
            ['id' => 36, 'name' => 'French (Switzerland)', 'code' => 'fr-CH', 'flag' => '/img/flags/ch.svg'],
            ['id' => 37, 'name' => 'German (Austria)', 'code' => 'de-AT', 'flag' => '/img/flags/at.svg'],
            ['id' => 38, 'name' => 'German (Germany)', 'code' => 'de-DE', 'flag' => '/img/flags/de.svg'],
            ['id' => 39, 'name' => 'German (Switzerland)', 'code' => 'de-CH', 'flag' => '/img/flags/ch.svg'],
            ['id' => 40, 'name' => 'Greek (Greece)', 'code' => 'el-GR', 'flag' => '/img/flags/gr.svg'],
            ['id' => 41, 'name' => 'Gujarati (India)', 'code' => 'gu-IN', 'flag' => '/img/flags/in.svg'],
            ['id' => 42, 'name' => 'Hebrew (Israel)', 'code' => 'he-IL', 'flag' => '/img/flags/il.svg'],
            ['id' => 43, 'name' => 'Hindi (India)', 'code' => 'hi-IN', 'flag' => '/img/flags/in.svg'],
            ['id' => 44, 'name' => 'Hungarian (Hungary)', 'code' => 'hu-HU', 'flag' => '/img/flags/hu.svg'],
            ['id' => 45, 'name' => 'Icelandic (Iceland)', 'code' => 'is-IS', 'flag' => '/img/flags/is.svg'],
            ['id' => 46, 'name' => 'Indonesian (Indonesia)', 'code' => 'id-ID', 'flag' => '/img/flags/id.svg'],
            ['id' => 47, 'name' => 'Irish (Ireland)', 'code' => 'ga-IE', 'flag' => '/img/flags/ie.svg'],
            ['id' => 48, 'name' => 'Italian (Italy)', 'code' => 'it-IT', 'flag' => '/img/flags/it.svg'],
            ['id' => 49, 'name' => 'Japanese (Japan)', 'code' => 'ja-JP', 'flag' => '/img/flags/jp.svg'],
            ['id' => 50, 'name' => 'Kannada (India)', 'code' => 'kn-IN', 'flag' => '/img/flags/in.svg'],
            ['id' => 51, 'name' => 'Korean (South Korea)', 'code' => 'ko-KR', 'flag' => '/img/flags/kr.svg'],
            ['id' => 52, 'name' => 'Latvian (Latvia)', 'code' => 'lv-LV', 'flag' => '/img/flags/lv.svg'],
            ['id' => 53, 'name' => 'Lithuanian (Lithuania)', 'code' => 'lt-LT', 'flag' => '/img/flags/lt.svg'],
            ['id' => 54, 'name' => 'Malayalam (India)', 'code' => 'ml-IN', 'flag' => '/img/flags/in.svg'],
            ['id' => 55, 'name' => 'Malay (Malaysia)', 'code' => 'ms-MY', 'flag' => '/img/flags/my.svg'],
            ['id' => 56, 'name' => 'Maltese (Malta)', 'code' => 'mt-MT', 'flag' => '/img/flags/mt.svg'],
            ['id' => 57, 'name' => 'Marathi (India)', 'code' => 'mr-IN', 'flag' => '/img/flags/in.svg'],
            ['id' => 58, 'name' => 'Norwegian (Norway)', 'code' => 'nb-NO', 'flag' => '/img/flags/no.svg'],
            ['id' => 59, 'name' => 'Polish (Poland)', 'code' => 'pl-PL', 'flag' => '/img/flags/pl.svg'],
            ['id' => 60, 'name' => 'Portuguese (Brazil)', 'code' => 'pt-BR', 'flag' => '/img/flags/br.svg'],
            ['id' => 61, 'name' => 'Portuguese (Portugal)', 'code' => 'pt-PT', 'flag' => '/img/flags/pt.svg'],
            ['id' => 62, 'name' => 'Romanian (Romania)', 'code' => 'ro-RO', 'flag' => '/img/flags/ro.svg'],
            ['id' => 63, 'name' => 'Russian (Russia)', 'code' => 'ru-RU', 'flag' => '/img/flags/ru.svg'],
            ['id' => 64, 'name' => 'Serbian (Serbia)', 'code' => 'sr-RS', 'flag' => '/img/flags/rs.svg'],
            ['id' => 65, 'name' => 'Slovak (Slovakia)', 'code' => 'sk-SK', 'flag' => '/img/flags/sk.svg'],
            ['id' => 66, 'name' => 'Slovenian (Slovenia)', 'code' => 'sl-SI', 'flag' => '/img/flags/si.svg'],
            ['id' => 67, 'name' => 'Spanish (Argentina)', 'code' => 'es-AR', 'flag' => '/img/flags/ar.svg'],
            ['id' => 68, 'name' => 'Spanish (Colombia)', 'code' => 'es-CO', 'flag' => '/img/flags/co.svg'],
            ['id' => 69, 'name' => 'Spanish (Spain)', 'code' => 'es-ES', 'flag' => '/img/flags/es.svg'],
            ['id' => 70, 'name' => 'Spanish (Mexico)', 'code' => 'es-MX', 'flag' => '/img/flags/mx.svg'],
            ['id' => 71, 'name' => 'Spanish (USA)', 'code' => 'es-US', 'flag' => '/img/flags/us.svg'],
            ['id' => 72, 'name' => 'Swahili (Kenya)', 'code' => 'sw-KE', 'flag' => '/img/flags/ke.svg'],
            ['id' => 73, 'name' => 'Swedish (Sweden)', 'code' => 'sv-SE', 'flag' => '/img/flags/se.svg'],
            ['id' => 74, 'name' => 'Tamil (India)', 'code' => 'ta-IN', 'flag' => '/img/flags/in.svg'],
            ['id' => 75, 'name' => 'Telugu (India)', 'code' => 'te-IN', 'flag' => '/img/flags/in.svg'],
            ['id' => 76, 'name' => 'Thai (Thailand)', 'code' => 'th-TH', 'flag' => '/img/flags/th.svg'],
            ['id' => 77, 'name' => 'Turkish (Turkey)', 'code' => 'tr-TR', 'flag' => '/img/flags/tr.svg'],
            ['id' => 78, 'name' => 'Ukrainian (Ukraine)', 'code' => 'uk-UA', 'flag' => '/img/flags/ua.svg'],
            ['id' => 79, 'name' => 'Urdu (Pakistan)', 'code' => 'ur-PK', 'flag' => '/img/flags/pk.svg'],
            ['id' => 80, 'name' => 'Vietnamese (Vietnam)', 'code' => 'vi-VN', 'flag' => '/img/flags/vn.svg'],
            ['id' => 81, 'name' => 'Welsh (Wales)', 'code' => 'cy-GB', 'flag' => '/img/flags/gb-wls.svg'],
            ['id' => 82, 'name' => 'Amharic (Ethiopia)', 'code' => 'am-ET', 'flag' => '/img/flags/et.svg'],
            ['id' => 83, 'name' => 'Arabic (Algeria)', 'code' => 'ar-DZ', 'flag' => '/img/flags/dz.svg'],
            ['id' => 84, 'name' => 'Arabic (Bahrain)', 'code' => 'ar-BH', 'flag' => '/img/flags/bh.svg'],
            ['id' => 85, 'name' => 'Arabic (Iraq)', 'code' => 'ar-IQ', 'flag' => '/img/flags/iq.svg'],
            ['id' => 86, 'name' => 'Arabic (Jordan)', 'code' => 'ar-JO', 'flag' => '/img/flags/jo.svg'],
            ['id' => 87, 'name' => 'Arabic (Kuwait)', 'code' => 'ar-KW', 'flag' => '/img/flags/kw.svg'],
            ['id' => 88, 'name' => 'Arabic (Libya)', 'code' => 'ar-LY', 'flag' => '/img/flags/ly.svg'],
            ['id' => 89, 'name' => 'Arabic (Morocco)', 'code' => 'ar-MA', 'flag' => '/img/flags/ma.svg'],
            ['id' => 90, 'name' => 'Arabic (Qatar)', 'code' => 'ar-QA', 'flag' => '/img/flags/qa.svg'],
            ['id' => 91, 'name' => 'Arabic (Syria)', 'code' => 'ar-SY', 'flag' => '/img/flags/sy.svg'],
            ['id' => 92, 'name' => 'Arabic (Tunisia)', 'code' => 'ar-TN', 'flag' => '/img/flags/tn.svg'],
            ['id' => 93, 'name' => 'Arabic (UAE)', 'code' => 'ar-AE', 'flag' => '/img/flags/ae.svg'],
            ['id' => 94, 'name' => 'Arabic (Yemen)', 'code' => 'ar-YE', 'flag' => '/img/flags/ye.svg'],
            ['id' => 95, 'name' => 'Bangla (Bangladesh)', 'code' => 'bn-BD', 'flag' => '/img/flags/bd.svg'],
            ['id' => 96, 'name' => 'Burmese (Myanmar)', 'code' => 'my-MM', 'flag' => '/img/flags/mm.svg'],
            ['id' => 97, 'name' => 'English (Kenya)', 'code' => 'en-KE', 'flag' => '/img/flags/ke.svg'],
            ['id' => 98, 'name' => 'English (Nigeria)', 'code' => 'en-NG', 'flag' => '/img/flags/ng.svg'],
            ['id' => 99, 'name' => 'English (Tanzania)', 'code' => 'en-TZ', 'flag' => '/img/flags/tz.svg'],
            ['id' => 100, 'name' => 'Galician (Spain)', 'code' => 'gl-ES', 'flag' => '/img/flags/es.svg'],
            ['id' => 101, 'name' => 'Javanese (Indonesia)', 'code' => 'jv-ID', 'flag' => '/img/flags/id.svg'],
            ['id' => 102, 'name' => 'Persian (Iran)', 'code' => 'fa-IR', 'flag' => '/img/flags/ir.svg'],
            ['id' => 103, 'name' => 'Khmer (Cambodia)', 'code' => 'km-KH', 'flag' => '/img/flags/kh.svg'],
            ['id' => 104, 'name' => 'Somali (Somalia)', 'code' => 'so-SO', 'flag' => '/img/flags/so.svg'],
            ['id' => 105, 'name' => 'Spanish (Bolivia)', 'code' => 'es-BO', 'flag' => '/img/flags/bo.svg'],
            ['id' => 106, 'name' => 'Spanish (Chile)', 'code' => 'es-CL', 'flag' => '/img/flags/cl.svg'],
            ['id' => 107, 'name' => 'Spanish (Costa Rica)', 'code' => 'es-CR', 'flag' => '/img/flags/cr.svg'],
            ['id' => 108, 'name' => 'Spanish (Cuba)', 'code' => 'es-CU', 'flag' => '/img/flags/cu.svg'],
            ['id' => 109, 'name' => 'Spanish (Dominican Republic)', 'code' => 'es-DO', 'flag' => '/img/flags/do.svg'],
            ['id' => 110, 'name' => 'Spanish (Ecuador)', 'code' => 'es-EC', 'flag' => '/img/flags/ec.svg'],
            ['id' => 111, 'name' => 'Spanish (El Salvador)', 'code' => 'es-SV', 'flag' => '/img/flags/sv.svg'],
            ['id' => 112, 'name' => 'Spanish (Equatorial Guinea)', 'code' => 'es-GQ', 'flag' => '/img/flags/gq.svg'],
            ['id' => 113, 'name' => 'Spanish (Guatemala)', 'code' => 'es-GT', 'flag' => '/img/flags/gt.svg'],
            ['id' => 115, 'name' => 'Spanish (Honduras)', 'code' => 'es-HN', 'flag' => '/img/flags/hn.svg'],
            ['id' => 116, 'name' => 'Spanish (Nicaragua)', 'code' => 'es-NI', 'flag' => '/img/flags/ni.svg'],
            ['id' => 117, 'name' => 'Spanish (Panama)', 'code' => 'es-PA', 'flag' => '/img/flags/pa.svg'],
            ['id' => 118, 'name' => 'Spanish (Paraguay)', 'code' => 'es-PY', 'flag' => '/img/flags/py.svg'],
            ['id' => 119, 'name' => 'Spanish (Peru)', 'code' => 'es-PE', 'flag' => '/img/flags/pe.svg'],
            ['id' => 120, 'name' => 'Spanish (Puerto Rico)', 'code' => 'es-PR', 'flag' => '/img/flags/pr.svg'],
            ['id' => 121, 'name' => 'Spanish (Uruguay)', 'code' => 'es-UY', 'flag' => '/img/flags/uy.svg'],
            ['id' => 122, 'name' => 'Spanish (Venezuela)', 'code' => 'es-VE', 'flag' => '/img/flags/ve.svg'],
            ['id' => 123, 'name' => 'Sundanese (Indonesia)', 'code' => 'su-ID', 'flag' => '/img/flags/id.svg'],
            ['id' => 124, 'name' => 'Swahili (Tanzania)', 'code' => 'sw-TZ', 'flag' => '/img/flags/tz.svg'],
            ['id' => 125, 'name' => 'Tamil (Singapore)', 'code' => 'ta-SG', 'flag' => '/img/flags/sg.svg'],
            ['id' => 126, 'name' => 'Tamil (Sri Lanka)', 'code' => 'ta-LK', 'flag' => '/img/flags/lk.svg'],
            ['id' => 127, 'name' => 'Urdu (India)', 'code' => 'ur-IN', 'flag' => '/img/flags/in.svg'],
            ['id' => 128, 'name' => 'Uzbek (Uzbekistan)', 'code' => 'uz-UZ', 'flag' => '/img/flags/uz.svg'],
            ['id' => 129, 'name' => 'Zulu (South Africa)', 'code' => 'zu-ZA', 'flag' => '/img/flags/za.svg'],
            ['id' => 130, 'name' => 'Kazakh (Kazakhstan)', 'code' => 'kk-KZ', 'flag' => '/img/flags/kz.svg'],
            ['id' => 131, 'name' => 'Lao (Laos)', 'code' => 'lo-LA', 'flag' => '/img/flags/la.svg'],
            ['id' => 132, 'name' => 'Macedonian (Macedonia)', 'code' => 'mk-MK', 'flag' => '/img/flags/mk.svg'],
            ['id' => 133, 'name' => 'Pashto (Afghanistan)', 'code' => 'ps-AF', 'flag' => '/img/flags/af.svg'],
            ['id' => 134, 'name' => 'Sinhala (Sri Lanka)', 'code' => 'si-LK', 'flag' => '/img/flags/lk.svg'],
            ['id' => 135, 'name' => 'Punjabi (India)', 'code' => 'pa-IN', 'flag' => '/img/flags/in.svg'],
            ['id' => 136, 'name' => 'Azerbaijani (Azerbaijan)', 'code' => 'az-AZ', 'flag' => '/img/flags/az.svg'],
            ['id' => 137, 'name' => 'Arabic (Lebanon)', 'code' => 'ar-LB', 'flag' => '/img/flags/lb.svg'],
            ['id' => 138, 'name' => 'Albanian (Albania)', 'code' => 'sq-AL', 'flag' => '/img/flags/al.svg'],
            ['id' => 139, 'name' => 'Georgian (Georgia)', 'code' => 'ka-GE', 'flag' => '/img/flags/ge.svg'],
            ['id' => 140, 'name' => 'Mongolian (Mongolia)', 'code' => 'mn-MN', 'flag' => '/img/flags/mn.svg'],
            ['id' => 141, 'name' => 'Nepali (Nepal)', 'code' => 'ne-NP', 'flag' => '/img/flags/np.svg'],
            ['id' => 142, 'name' => 'Bosnian (Bosnia and Herzegovina)', 'code' => 'bs-BA', 'flag' => '/img/flags/ba.svg'],
            ['id' => 143, 'name' => 'Arabic (Oman)', 'code' => 'ar-OM', 'flag' => '/img/flags/om.svg'],
            ['id' => 144, 'name' => 'Tamil (Malaysia)', 'code' => 'ta-MY', 'flag' => '/img/flags/my.svg'],
        ];


        foreach ($languages as $language) {
            VoiceLanguage::updateOrCreate(['id' => $language['id']], $language);
        }
    }
}
