<table class="table tt-footable border-top align-middle" data-use-parent-width="true">
    <thead>
        <tr>
            <th class="text-center"><?php echo e(localize('S/L')); ?></th>
            <th><?php echo e(localize('Project Name')); ?></th>
            <th data-breakpoints="xs sm"><?php echo e(localize('Created Date')); ?></th>
            <th data-breakpoints="xs sm"><?php echo e(localize('Type')); ?></th>
            <th data-breakpoints="xs sm md"><?php echo e(localize('Words/Size')); ?></th>
            <th data-breakpoints="xs sm md" class="text-end"><?php echo e(localize('Action')); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td class="text-center fs-sm">
                    <?php echo e($key + 1 + ($projects->currentPage() - 1) * $projects->perPage()); ?>

                </td>

                <td>
                    <a <?php if($project->content_type == 'image'): ?>
                        <?php
                            $image_path = $project->storage_type == 'aws' ? $project->content : staticAsset($project->content);
                        ?> 
                        
                        href="<?php echo e($image_path); ?>"
                        <?php else: ?> 
                        href="<?php echo e(route('projects.edit', ['slug' => $project->slug, 'lang_key' => env('DEFAULT_LANGUAGE')])); ?>&localize" <?php endif; ?>
                        class="d-flex align-items-center" <?php if($newTab || $project->content_type == 'image'): ?> target="_blank" <?php endif; ?>>
                        <div class="avatar avatar-sm">
                            <div class="text-center"><span data-feather="<?php echo e(getProjectIcon($project->content_type)); ?>"
                                    class="text-muted icon-16"></span>
                            </div>
                        </div>
                        <div class="ms-1">
                            <h6 class="fs-sm mb-0"> <?php echo e($project->title); ?></h6>
                        </div>
                    </a>
                </td>

                <td>
                    <span class="fs-sm"><?php echo e(date('d M, Y', strtotime($project->created_at))); ?></span>
                </td>

                <td>
                    <span
                        class="fs-sm text-capitalize"><?php echo e(localize(ucwords(str_replace('_', ' ', $project->content_type)))); ?></span>
                </td>

                <td>
                    <span class="fs-sm fw-bold">
                        <?php if($project->content_type == 'image'): ?>
                            <?php echo e($project->resolution); ?>

                        <?php else: ?>
                            <?php echo e($project->words); ?>

                        <?php endif; ?>
                    </span>
                </td>

                <td class="text-end">
                    <div class="dropdown tt-tb-dropdown">
                        <button type="button" class="btn p-0" data-bs-toggle="dropdown" aria-expanded="false">
                            <i data-feather="more-vertical"></i>
                        </button>
                        <div class="dropdown-menu dropdown-menu-end shadow" style="">
                            <a class="dropdown-item" <?php if($newTab || $project->content_type == 'image'): ?> target="_blank" <?php endif; ?>
                                <?php if($project->content_type == 'image'): ?> href="<?php echo e(staticAsset($project->content)); ?>"
                        <?php else: ?> 
                        href="<?php echo e(route('projects.edit', ['slug' => $project->slug, 'lang_key' => env('DEFAULT_LANGUAGE')])); ?>&localize" <?php endif; ?>>
                                <i data-feather="edit-3" class="me-2"></i><?php echo e(localize('View Contents')); ?>

                            </a>

                            <a href="#" class="dropdown-item confirm-delete"
                                <?php if($project->content_type == 'image'): ?> data-href="<?php echo e(route('images.delete', $project->id)); ?>" 
                                <?php else: ?>
                                data-href="<?php echo e(route('projects.delete', $project->id)); ?>" <?php endif; ?>
                                title="<?php echo e(localize('Delete')); ?>">
                                <i data-feather="trash-2" class="me-2"></i>
                                <?php echo e(localize('Delete')); ?>

                            </a>
                        </div>
                    </div>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<?php /**PATH E:\xampp\htdocs\ai\pinterai\resources\views/backend/pages/projects/inc/projectTable.blade.php ENDPATH**/ ?>