

<?php $__env->startSection('title'); ?>
    <?php echo e(localize('Dashboard')); ?> <?php echo e(getSetting('title_separator')); ?> <?php echo e(getSetting('system_title')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('contents'); ?>
    <?php
        $user = auth()->user();
        $totalText = \App\Models\SubscriptionHistory::sum('total_used_words');

        $totalImages = \App\Models\Project::where('content_type', 'image')->count();
        $totalCode = \App\Models\Project::where('content_type', 'code')->count();
        $totalS2T = \App\Models\Project::where('content_type', 'speech_to_text')->count();
        
        $recentProjectIds = \App\Models\Project::latest()
            ->where('user_id', $user->id)
            ->take(30)
            ->pluck('id');
        
        $recentProjects = \App\Models\Project::latest()
            ->whereIn('id', $recentProjectIds)
            ->paginate(10);
        
        if (isCustomer()) {
            $totalText = \App\Models\SubscriptionHistory::where('user_id', $user->id)->sum('total_used_words');        
            $totalImages = \App\Models\SubscriptionHistory::where('user_id', $user->id)->sum('total_used_images');
        
            $totalCode = \App\Models\Project::where('user_id', $user->id)
                ->where('content_type', 'code')
                ->count();            
            $totalS2T = \App\Models\SubscriptionHistory::where('user_id', $user->id)->sum('total_used_s2t');
        } else {
            $totalText += \App\Models\AiBlogWizard::whereNull('subscription_history_id')->sum('total_words');
        }
       
    ?>

    <section class="tt-section pt-4">

        <div class="container">
            <div class="row mb-4">
                <div class="col-12">
                    <div class="tt-page-header ">
                        <div class="d-lg-flex align-items-center justify-content-lg-between">
                            <div class="tt-page-title mb-3 mb-lg-0">
                                <h1 class="h4 mb-lg-1"><?php echo e(localize('Dashboard')); ?></h1>
                                <ol class="breadcrumb breadcrumb-angle text-muted">
                                    <li class="breadcrumb-item"><a
                                            href="<?php echo e(route('writebot.dashboard')); ?>"><?php echo e(localize('Dashboard')); ?></a></li>
                                    <li class="breadcrumb-item"><?php echo e(localize('Overview')); ?></li>
                                </ol>
                            </div>
                            <div class="tt-action d-flex gap-2 flex-wrap">
                                <a href="<?php echo e(route('templates.index')); ?>" class="btn btn-secondary"><i
                                        data-feather="file-plus" class="me-2"></i> <?php echo e(localize('Create Content')); ?></a>
                                <?php if(auth()->user()->user_type != 'customer'): ?>
                                    <a href="<?php echo e(route('subscriptions.index')); ?>" class="btn btn-primary"><i
                                            data-feather="zap"
                                            class="me-2"></i><?php echo e(localize('Subscription Packages')); ?></a>
                                <?php endif; ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mb-3 g-3">

                <?php if(isCustomer()): ?>
                    <div class="col-xl-7">
                        <div class="card">
                            <div class="card-body pb-0">
                                <div class="d-flex flex-wrap">
                                    <div class="me-3">
                                        <div class="avatar avatar-2xl">
                                            <img class="rounded" src="<?php echo e(uploadedAsset($user->avatar)); ?>" alt="avatar"
                                                onerror="this.onerror=null;this.src='<?php echo e(staticAsset('/backend/assets/img/avatar/1.jpg')); ?>';" />
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h2 class="h5 mb-2"><?php echo e($user->name); ?></h2>
                                        <ul class="d-flex flex-wrap list-unstyled">
                                            <li class="me-3"><i data-feather="mail"
                                                    class="me-1 text-muted icon-14"></i><?php echo e($user->email); ?></li>
                                            <?php if($user->phone): ?>
                                                <li class="me-3"><i data-feather="phone"
                                                        class="me-1 text-muted icon-14"></i><?php echo e($user->phone); ?></li>
                                            <?php endif; ?>

                                        </ul>
                                        <div class="d-flex align-items-center flex-column mt-4">

                                            <div class="d-flex justify-content-between w-100 mt-auto mb-2">
                                                <?php
                                                    
                                                    $latestPackage = activePackageHistory();
                                                    $totalWords = $latestPackage != null ? $latestPackage->this_month_available_words + $latestPackage->this_month_used_words : 0;
                                                ?>
                                                 <?php if($latestPackage): ?>
                                                    <?php if($latestPackage->new_word_balance != -1): ?>
                                                    <span class="fs-base"><strong>
                                                            <?php if($latestPackage != null): ?>
                                                                <?php echo e($latestPackage->this_month_used_words > $totalWords ? $totalWords : $latestPackage->this_month_used_words); ?>

                                                            <?php else: ?>
                                                                0
                                                            <?php endif; ?>
                                                        </strong>
                                                        <?php echo e(localize('Used out of')); ?>

                                                        <strong><?php echo e($totalWords); ?></strong>
                                                        <?php echo e(localize('words.')); ?></span>
                                                    <span class="fs-base fw-bold"><?php echo e(getUsedWordsPercentage()); ?>%</span>
                                                    <?php endif; ?>
                                                 <?php endif; ?>
                                            </div>
                                            <?php if($latestPackage): ?>
                                                <?php if($latestPackage->new_word_balance != -1): ?>
                                                <div class="progress mb-2 w-100" style="height: 8px;">
                                                    <div class="progress-bar bg-warning" role="progressbar"
                                                        style="width:  <?php echo e(getUsedWordsPercentage()); ?>%"
                                                        aria-valuenow="<?php echo e(getUsedWordsPercentage()); ?>" aria-valuemin="0"
                                                        aria-valuemax="100"></div>
                                                </div>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <ul class="nav nav-line-tab fw-semibold">
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('writebot.dashboard')); ?>" class="nav-link active">
                                            <?php echo e(localize('Overview')); ?>

                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('subscriptions.index')); ?>" class="nav-link">
                                            <?php echo e(localize('Subscriptions')); ?>

                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('subscriptions.histories.index')); ?>" class="nav-link">
                                            <?php echo e(localize('Histories')); ?>

                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a href="<?php echo e(route('dashboard.profile')); ?>" class="nav-link">
                                            <?php echo e(localize('Profile')); ?>

                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="<?php echo e(isCustomer() ? 'col-xl-5' : 'col-xl-12'); ?>">
                    <div class="row g-3">
                        
                        <div class="<?php echo e(isCustomer() ? 'col-6' : 'col-md-3'); ?>">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="avatar me-2 flex-shrink-0">
                                            <div class="text-center rounded bg-soft-primary">
                                                <span><i data-feather="file-text"></i></span>
                                            </div>
                                        </div>

                                        <div class="flex-grow-1">
                                            <h6 class="mb-0"><?php echo e($totalText); ?></h6>
                                            <span class="fs-sm"><?php echo e(localize('Total words generated')); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <?php if(getSetting('enable_ai_images') != '0'): ?>
                            <div class="<?php echo e(isCustomer() ? 'col-6' : 'col-md-3'); ?>">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center">
                                            <div class="avatar me-2 flex-shrink-0">
                                                <div class="text-center rounded bg-soft-accent">
                                                    <span><i data-feather="image"></i></span>
                                                </div>
                                            </div>
                                            <div class="flex-grow-1">
                                                <h6 class="mb-0"><?php echo e($totalImages); ?></h6>
                                                <span class="fs-sm"><?php echo e(localize('Total Image generated')); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <?php if(getSetting('enable_ai_code') != '0'): ?>
                            <div class="<?php echo e(isCustomer() ? 'col-6' : 'col-md-3'); ?>">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center">
                                            <div class="avatar me-2 flex-shrink-0">
                                                <div class="text-center rounded bg-soft-info">
                                                    <span><i data-feather="code"></i></span>
                                                </div>
                                            </div>
                                            <div class="flex-grow-1">
                                                <h6 class="mb-0"><?php echo e($totalCode); ?></h6>
                                                <span class="fs-sm"><?php echo e(localize('Total code generated')); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <?php if(getSetting('enable_speech_to_text') != '0'): ?>
                        <div class="<?php echo e(isCustomer() ? 'col-6' : 'col-md-3'); ?>">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="avatar me-2 flex-shrink-0">
                                            <div class="text-center rounded bg-soft-danger">
                                                <span><i data-feather="mic"></i></span>
                                            </div>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="mb-0"><?php echo e($totalS2T); ?></h6>
                                            <span class="fs-sm"><?php echo e(localize('Total speech to text')); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php if(getSetting('enable_built_in_templates') != '0'): ?>
            <div class="row g-3 mb-3">
                <div class="<?php echo e(isCustomer() ? 'col-12' : 'col-md-8'); ?>">
                    <div class="card h-100 flex-column">
                        <div class="card-body d-flex flex-column h-100">
                            <div class="d-flex align-items-center justify-content-between">
                                <span class="text-muted"><?php echo e(localize('Total Words Generated with templates')); ?></span>
                                <div class="dropdown tt-tb-dropdown fs-sm">
                                    <a class="dropdown-toggle text-muted" href="#" data-bs-toggle="dropdown"
                                        aria-haspopup="true" aria-expanded="false">
                                        <?php if(isset($timelineText)): ?>
                                            <?php echo e($timelineText); ?>

                                        <?php else: ?>
                                            <?php echo e(localize('Last 7 days')); ?>

                                        <?php endif; ?>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-end shadow">
                                        <a class="dropdown-item"
                                            href="<?php echo e(route('writebot.dashboard')); ?>"><?php echo e(localize('Last 7 days')); ?></a>
                                        <a class="dropdown-item"
                                            href="<?php echo e(route('writebot.dashboard')); ?>?&timeline=30"><?php echo e(localize('Last 30 days')); ?></a>
                                        <a class="dropdown-item"
                                            href="<?php echo e(route('writebot.dashboard')); ?>?&timeline=90"><?php echo e(localize('Last 3 months')); ?></a>
                                    </div>
                                </div>
                            </div>
                            <h4 class="fw-bold"><?php echo e(formatWords($totalWordsData->totalWords)); ?>

                                <?php echo e(localize('Words')); ?></h4>
                        </div>

                        <div id="chart"></div>
                    </div>
                </div>
                <?php if(auth()->user()->user_type != 'customer'): ?>
                    <div class="col-xl-4">
                        <div class="card h-100 flex-column">
                            <div class="card-body d-flex flex-column h-100">
                                <span class="text-muted"><?php echo e(localize('Top 5 Templates')); ?></span>
                                <h4 class="fw-bold">
                                    <?php echo e(getSetting('truncate_price') == 1 ? formatWords($totalTemplateWordsData->totalTemplateWordsCount) : $totalTemplateWordsData->totalTemplateWordsCount); ?>

                                    <?php echo e(localize('Words')); ?></h4>
                                <div id="donut"></div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <?php endif; ?>
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header border-bottom-0">
                            <div class="row justify-content-between align-items-center g-3">
                                <div class="col-auto flex-grow-1">
                                    <h5 class="mb-lg-0"><?php echo e(localize('Recent Projects')); ?></h5>
                                </div>
                            </div>
                        </div>
                        <?php echo $__env->make('backend.pages.projects.inc.projectTable', [
                            'projects' => $recentProjects,
                            'newTab' => false,
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <!--pagination start-->
                        <div class="d-flex align-items-center justify-content-between px-4 pb-4">
                            <span><?php echo e(localize('Showing')); ?>

                                <?php echo e($recentProjects->firstItem() ?? 0); ?>-<?php echo e($recentProjects->lastItem() ?? 0); ?>

                                <?php echo e(localize('of')); ?>

                                <?php echo e($recentProjects->total()); ?> <?php echo e(localize('results')); ?></span>
                            <nav>
                                <?php echo e($recentProjects->appends(request()->input())->links()); ?>

                            </nav>
                        </div>
                        <!--pagination end-->
                    </div>
                </div>
            </div>

        </div>
    </section>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script>
        "use strict";
        // total earning chart
        var totalSales = {
            chart: {
                type: "area",
                height: 80,
                sparkline: {
                    enabled: true,
                },
            },
            stroke: {
                curve: "smooth",
                width: 2,
            },
            fill: {
                opacity: 1,
            },
            series: [{
                name: '<?php echo e(localize('Words')); ?>',
                data: [<?php echo $totalWordsData->words; ?>],
            }, ],
            labels: [<?php echo $totalWordsData->labels; ?>],
            xaxis: {
                type: "datetime",
            },
            yaxis: {
                min: 0,
            },
            colors: ["#9333ea"],
        };
        new ApexCharts(document.querySelector("#chart"), totalSales).render();

        if ('<?php echo e(auth()->user()->user_type); ?>' != 'customer') {
            //pie chart top five
            var optionsTopFive = {
                chart: {
                    type: "donut",
                    height: 100,
                    offsetY: 15,
                    offsetX: -20,
                },
                series: <?php echo $totalTemplateWordsData->series; ?>,
                labels: [<?php echo $totalTemplateWordsData->labels; ?>],
                responsive: [{
                    breakpoint: 480,
                    options: {
                        chart: {
                            width: 200,
                        },
                        legend: {
                            position: "bottom",
                            show: false,
                        },
                        dataLabels: {
                            enabled: false,
                        },
                    },
                }, ],
            };

            var chartTopFive = new ApexCharts(
                document.querySelector("#donut"),
                optionsTopFive
            );
            chartTopFive?.render();
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\ai\pinterai\resources\views/backend/pages/dashboard.blade.php ENDPATH**/ ?>