


<?php $__env->startSection('title'); ?>
    <?php echo e(localize('Templates')); ?> <?php echo e(getSetting('title_separator')); ?> <?php echo e(getSetting('system_title')); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('contents'); ?>
    <section class="tt-section pt-4">
        <div class="container">
            <div class="row mb-4">
                <div class="col-12">
                    <div class="tt-page-header">
                        <div class="d-lg-flex align-items-center justify-content-lg-between">
                            <div class="tt-page-title mb-3 mb-lg-0">
                                <h1 class="h4 mb-lg-1"><?php echo e(localize('All Templates')); ?></h1>
                                <ol class="breadcrumb breadcrumb-angle text-muted">
                                    <li class="breadcrumb-item"><a
                                            href="<?php echo e(route('writebot.dashboard')); ?>"><?php echo e(localize('Dashboard')); ?></a>
                                    </li>
                                    <li class="breadcrumb-item"><?php echo e(localize('Templates')); ?></li>
                                </ol>
                            </div>
                            <div class="tt-action">
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="row mb-3 g-3">
                <div class="col-xl-12">
                    <div class="card h-100 bg-secondary-subtle">
                        <div class="card-header sticky-top-card bg-secondary py-lg-5 py-4">
                            <!-- template search -->
                            <form action="<?php echo e(Request::fullUrl()); ?>" method="GET">
                                <div class="row justify-content-center">
                                    <div class="col-lg-6 col-md-8">
                                        <div class="input-group">
                                            <input type="search"
                                                placeholder="<?php echo e(localize('Search template that you are looking for')); ?>..."
                                                name="search"
                                                <?php if(isset($searchKey)): ?>
                                        value="<?php echo e($searchKey); ?>"
                                    <?php endif; ?>
                                                class="form-control border border-2 border-primary rounded-pill rounded-end">
                                            <div class="input-group-append">
                                                <button type="submit"
                                                    class="btn btn-link bg-primary border border-2 border-primary text-light rounded-pill rounded-start"><i
                                                        class="flaticon-search translate-middle-y"></i><?php echo e(localize('Search Now')); ?></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>

                            <div class="tt-advance-options cursor-pointer d-block d-lg-none text-center mt-3">
                                <label for="tt-advance-options"
                                    class="form-label cursor-pointer mb-0 btn btn-light shadow-sm btn-sm rounded-pill"><span
                                        class="fw-bold tt-promot-number fw-bold me-1"></span><?php echo e(localize('Show Category')); ?>

                                    <span><i data-feather="plus" class="icon-16 text-primary ms-2"></i></span></label>
                                <div class="tt-advance-options-wrapper" id="tt-advance-options">
                                    <ul class="nav nav-pills d-flex justify-content-center tt-horizontal-tab mt-3"
                                        id="pills-tab" role="tablist">

                                        <li class="nav-item mb-2" role="presentation">
                                            <a class="nav-link rounded-pill active" id="tabId-all"data-bs-toggle="pill"
                                                data-bs-target="#all-tab" type="button" role="tab"
                                                aria-controls="all-tab" aria-selected="true" href="#">
                                                <i data-feather="book" class="me-1 icon-16"></i>
                                                <?php echo e(localize('All Templates')); ?>

                                            </a>
                                        </li>

                                        <?php $__currentLoopData = $templateGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="nav-item mb-2" role="presentation">
                                                <a class="nav-link rounded-pill" id="tabId-<?php echo e($group->slug); ?>"
                                                    data-bs-toggle="pill" data-bs-target="#tab-<?php echo e($group->slug); ?>"
                                                    type="button" role="tab" aria-controls="tab-<?php echo e($group->slug); ?>"
                                                    aria-selected="true" href="#">
                                                    <i data-feather="<?php echo e($group->icon); ?>" class="me-1 icon-16"></i>
                                                    <?php echo e(localize($group->name)); ?></a>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>

                                </div>
                            </div>



                            <div class="d-none d-lg-block">
                                <ul class="nav nav-pills d-flex justify-content-center tt-horizontal-tab mt-3"
                                    id="pills-tab" role="tablist">

                                    <li class="nav-item mb-2" role="presentation">
                                        <a class="nav-link rounded-pill active" id="tabId-all"data-bs-toggle="pill"
                                            data-bs-target="#all-tab" type="button" role="tab" aria-controls="all-tab"
                                            aria-selected="true" href="#">
                                            <i data-feather="book" class="me-1 icon-16"></i>
                                            <?php echo e(localize('All Templates')); ?>

                                        </a>
                                    </li>

                                    <?php $__currentLoopData = $templateGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item mb-2" role="presentation">
                                            <a class="nav-link rounded-pill" id="tabId-<?php echo e($group->slug); ?>"
                                                data-bs-toggle="pill" data-bs-target="#tab-<?php echo e($group->slug); ?>"
                                                type="button" role="tab" aria-controls="tab-<?php echo e($group->slug); ?>"
                                                aria-selected="true" href="#">
                                                <i data-feather="<?php echo e($group->icon); ?>" class="me-1 icon-16"></i>
                                                <?php echo e(localize($group->name)); ?></a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>





                        <?php
                            $user = auth()->user();
                            $subscriptionTemplates = [];
                        ?>

                        <div class="tab-content card-body" id="pills-tabContent">
                            <div class="tab-pane fade show active" id="all-tab" role="tabpanel"
                                aria-labelledby="tabId-all" tabindex="0">
                                <div class="row g-3">

                                    <?php if(isCustomer()): ?>
                                        <?php
                                            $package = optional(activePackageHistory())->subscriptionPackage ?? new \App\Models\SubscriptionPackage();
                                            // subscription package template based on template
                                            $subscriptionTemplates = \App\Models\SubscriptionPackageTemplate::where('subscription_package_id', $package->id)
                                                ->pluck('template_id')
                                                ->toArray();
                                        ?>
                                    <?php endif; ?>

                                    <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-lg-3 col-sm-6">
                                            <?php echo $__env->make('backend.pages.templates.inc.template-card', [
                                                'template' => $template,
                                                'subscriptionTemplates' => $subscriptionTemplates,
                                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>


                            <!-- loop -->
                            <?php $__currentLoopData = $templateGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="tab-pane fade" role="tabpanel" aria-labelledby="tabId-<?php echo e($group->slug); ?>"
                                    id="tab-<?php echo e($group->slug); ?>">
                                    <div class="row g-3">
                                        <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($template->template_group_id == $group->id): ?>
                                                <div class="col-lg-3 col-sm-6">
                                                    <?php echo $__env->make('backend.pages.templates.inc.template-card', [
                                                        'template' => $template,
                                                        'subscriptionTemplates' => $subscriptionTemplates,
                                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                </div>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make('backend.pages.templates.inc.template-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\ai\pinterai\resources\views/backend/pages/templates/index.blade.php ENDPATH**/ ?>