<ul class="tt-side-nav">

    <!-- dashboard -->
    <li class="side-nav-item nav-item">
        <a href="<?php echo e(route('writebot.dashboard')); ?>" class="side-nav-link">
            <span class="tt-nav-link-icon"><i data-feather="pie-chart"></i></span>
            <span class="tt-nav-link-text"><?php echo e(localize('Dashboard')); ?></span>
        </a>
    </li>

    <!-- subscriptions -->
    <?php
        $subscriptionActiveRoutes = ['subscriptions.index', 'subscriptions.create', 'subscriptions.edit', 'subscriptions.histories.index', 'payment_request'];
    ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['subscriptions', 'subscriptions_histories', 'payment_request', 'subscriptions_settings'])): ?>
        <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($subscriptionActiveRoutes, 'tt-menu-item-active')); ?>">
            <a data-bs-toggle="collapse" href="#subscription"
                aria-expanded="<?php echo e(areActiveRoutes($subscriptionActiveRoutes, 'true')); ?>" aria-controls="subscription"
                class="side-nav-link tt-menu-toggle">
                <span class="tt-nav-link-icon"><i data-feather="zap"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('Subscriptions')); ?></span>
            </a>
            <div class="collapse <?php echo e(areActiveRoutes($subscriptionActiveRoutes, 'show')); ?>" id="subscription">
                <ul class="side-nav-second-level">

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('subscriptions_histories')): ?>
                        <li class="<?php echo e(areActiveRoutes(['subscriptions.histories.index'], 'tt-menu-item-active')); ?>">
                            <a href="<?php echo e(route('subscriptions.histories.index')); ?>"><?php echo e(localize('Subscription Histories')); ?></a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payment_request')): ?>
                        <li class="<?php echo e(areActiveRoutes(['admin.payment-request.index'], 'tt-menu-item-active')); ?>">
                            <a href="<?php echo e(route('admin.payment-request.index')); ?>"><?php echo e(localize('Payment Request')); ?>

                                <span class="tt-nav-link-text">

                                    <?php
                                        $newMsgCount = \App\Models\SubscriptionHistory::where('payment_method', 'offline')->where('payment_status', '!=', 1)->count();
                                    ?>

                                    <?php if($newMsgCount > 0): ?>
                                        <small class="badge bg-danger"><?php echo e(localize('New')); ?></small>
                                    <?php endif; ?>
                                </span>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('subscriptions')): ?>
                        <li
                            class="<?php echo e(areActiveRoutes(['subscriptions.index', 'subscriptions.create', 'subscriptions.edit'], 'tt-menu-item-active')); ?>">
                            <a href="<?php echo e(route('subscriptions.index')); ?>"
                                class="<?php echo e(areActiveRoutes(['subscriptions.index', 'subscriptions.create', 'subscriptions.edit'])); ?>"><?php echo e(localize('Subscription Packages')); ?></a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('subscriptions_settings')): ?>
                        <li class="<?php echo e(areActiveRoutes(['admin.subscription-settings.index'], 'tt-menu-item-active')); ?>">
                            <a href="<?php echo e(route('admin.subscription-settings.index')); ?>"
                                class="<?php echo e(areActiveRoutes(['admin.subscription-settings.index'])); ?>"><?php echo e(localize('Subscription Settings')); ?></a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </li>
    <?php endif; ?>

    <!-- affiliate system -->
    <?php
        $affiliateActiveRoutes = ['affiliate.configurations', 'affiliate.withdraw.index', 'affiliate.earnings.index', 'affiliate.payments.index'];
    ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['affiliate_configurations', 'affiliate_withdraw', 'affiliate_earning_histories',
        'affiliate_payment_histories'])): ?>
        <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($affiliateActiveRoutes, 'tt-menu-item-active')); ?>">
            <a data-bs-toggle="collapse" href="#affiliate"
                aria-expanded="<?php echo e(areActiveRoutes($affiliateActiveRoutes, 'true')); ?>" aria-controls="affiliate"
                class="side-nav-link tt-menu-toggle">
                <span class="tt-nav-link-icon"><i data-feather="percent"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('Affiliate System')); ?></span>
            </a>
            <div class="collapse <?php echo e(areActiveRoutes($affiliateActiveRoutes, 'show')); ?>" id="affiliate">
                <ul class="side-nav-second-level">

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('affiliate_configurations')): ?>
                        <li class="<?php echo e(areActiveRoutes(['affiliate.configurations'], 'tt-menu-item-active')); ?>">
                            <a href="<?php echo e(route('affiliate.configurations')); ?>"><?php echo e(localize('Configurations')); ?></a>
                        </li>
                    <?php endif; ?>

                    <?php if(getSetting('enable_affiliate_system') == '1'): ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('affiliate_withdraw')): ?>
                            <li class="<?php echo e(areActiveRoutes(['affiliate.withdraw.index'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('affiliate.withdraw.index')); ?>"><?php echo e(localize('Withdraw Requests')); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('affiliate_earning_histories')): ?>
                            <li class="<?php echo e(areActiveRoutes(['affiliate.earnings.index'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('affiliate.earnings.index')); ?>"><?php echo e(localize('Earning Histories')); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('affiliate_payment_histories')): ?>
                            <li class="<?php echo e(areActiveRoutes(['affiliate.payments.index'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('affiliate.payments.index')); ?>"><?php echo e(localize('Payment Histories')); ?></a>
                            </li>
                        <?php endif; ?>
                    <?php endif; ?>
                </ul>
            </div>
        </li>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['folders', 'projects'])): ?>
        <!-- documents -->
        <li class="side-nav-title side-nav-item nav-item mt-3">
            <span class="tt-nav-title-text text-muted"><?php echo e(localize('Manage Documents')); ?></span>
        </li>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('folders')): ?>
            <li
                class="side-nav-item nav-item <?php echo e(areActiveRoutes(['folders.index', 'folders.show', 'folders.edit', 'folders.update'], 'tt-menu-item-active')); ?>">
                <a href="<?php echo e(route('folders.index')); ?>" class="side-nav-link">
                    <span class="tt-nav-link-icon"> <i data-feather="folder-plus"></i></span>
                    <span class="tt-nav-link-text"><?php echo e(localize('Folders')); ?></span>
                </a>
            </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('projects')): ?>
            <li
                class="side-nav-item nav-item <?php echo e(areActiveRoutes(['projects.index', 'projects.edit', 'projects.update'], 'tt-menu-item-active')); ?>">
                <a href="<?php echo e(route('projects.index')); ?>" class="side-nav-link">
                    <span class="tt-nav-link-icon"> <i data-feather="grid"></i></span>
                    <span class="tt-nav-link-text"><?php echo e(localize('All Projects')); ?></span>
                </a>
            </li>
        <?php endif; ?>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['ai_chat', 'ai_vision', 'ai_image_chat', 'ai_pdf_chat', 'ai_rewriter', 'blog_wizard', 'chat.prompts',
        'chat.storePrompt', 'chat.createPrompt', 'chat.editPrompt', 'chat.experts', 'chat.editExpert', 'templates',
        'speech_to_text', 'generate_images', 'generate_code', 'text_to_speech'])): ?>

        <!-- Templates -->
        <li class="side-nav-title side-nav-item nav-item mt-3">
            <span class="tt-nav-title-text text-muted"><?php echo e(localize('AI Tools')); ?></span>
        </li>

        <?php if(getSetting('enable_ai_chat') != '0'): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ai_chat')): ?>
                <li
                    class="side-nav-item nav-item <?php echo e(areActiveRoutes(['chat.index', 'chat.prompts', 'chat.storePrompt', 'chat.createPrompt', 'chat.editPrompt', 'chat.experts', 'chat.editExpert', 'chat.createExpert'], 'tt-menu-item-active')); ?>">
                    <a href="<?php echo e(route('chat.experts')); ?>" class="side-nav-link">
                        <span class="tt-nav-link-icon"> <i data-feather="message-square"></i></span>
                        <span class="tt-nav-link-text"><?php echo e(localize('AI Chat')); ?></span>
                    </a>
                </li>
            <?php endif; ?>
        <?php endif; ?>

        <?php if(getSetting('enable_ai_vision') != '0'): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ai_vision')): ?>
                <li class="side-nav-item nav-item <?php echo e(areActiveRoutes(['vision.index'], 'tt-menu-item-active')); ?>">
                    <a href="<?php echo e(route('vision.index')); ?>" class="side-nav-link">
                        <span class="tt-nav-link-icon"> <i data-feather="crosshair"></i></span>
                        <span class="tt-nav-link-text"><?php echo e(localize('AI Vision')); ?></span>
                    </a>
                </li>
            <?php endif; ?>
        <?php endif; ?>

        <?php if(getSetting('enable_ai_image_chat') != '0'): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ai_image_chat')): ?>
                <li class="side-nav-item nav-item <?php echo e(areActiveRoutes(['imageChat.index'], 'tt-menu-item-active')); ?>">
                    <a href="<?php echo e(route('imageChat.index')); ?>" class="side-nav-link">
                        <span class="tt-nav-link-icon"> <i data-feather="image"></i></span>
                        <span class="tt-nav-link-text"><?php echo e(localize('AI Chat Image')); ?></span>
                    </a>
                </li>
            <?php endif; ?>
        <?php endif; ?>
        
        <?php if(getSetting('enable_ai_pdf_chat') != '0'): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ai_pdf_chat')): ?>
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('pdfChat.index')); ?>" class="side-nav-link">
                        <span class="tt-nav-link-icon"> <i data-feather="message-circle"></i></span>
                        <span class="tt-nav-link-text"><?php echo e(localize('AI PDF Chat')); ?></span>
                    </a>
                </li>
            <?php endif; ?>
        <?php endif; ?>
        <?php if(getSetting('enable_ai_rewriter') != '0'): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ai_rewriter')): ?>
                <li class="side-nav-item nav-item <?php echo e(areActiveRoutes(['aiRewriter.index'], 'tt-menu-item-active')); ?>">
                    <a href="<?php echo e(route('aiRewriter.index')); ?>" class="side-nav-link">
                        <span class="tt-nav-link-icon"> <i data-feather="edit-3"></i></span>
                        <span class="tt-nav-link-text"><?php echo e(localize('AI ReWriter')); ?></span>
                    </a>
                </li>
            <?php endif; ?>
        <?php endif; ?>


        <?php if(getSetting('enable_blog_wizard') != '0'): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['blog_wizard'])): ?>
                <?php
                    $blogWizardActiveRoutes = ['blog.wizard', 'blog.wizard.create', 'blog.wizard.view', 'blog.wizard.edit'];
                ?>
                <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($blogWizardActiveRoutes, 'tt-menu-item-active')); ?>">
                    <a data-bs-toggle="collapse" href="#aiBlogWizard"
                        aria-expanded="<?php echo e(areActiveRoutes($blogWizardActiveRoutes, 'true')); ?>" aria-controls="aiBlogWizard"
                        class="side-nav-link tt-menu-toggle">
                        <span class="tt-nav-link-icon"><i data-feather="bold"></i></span>
                        <span class="tt-nav-link-text"><?php echo e(localize('AI Blog Wizard')); ?></span>
                    </a>
                    <div class="collapse <?php echo e(areActiveRoutes($blogWizardActiveRoutes, 'show')); ?>" id="aiBlogWizard">
                        <ul class="side-nav-second-level">

                            <li
                                class="<?php echo e(areActiveRoutes(['blog.wizard', 'blog.wizard.view', 'blog.wizard.edit'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('blog.wizard')); ?>"><?php echo e(localize('All Articles')); ?></a>
                            </li>

                            <li class="<?php echo e(areActiveRoutes(['blog.wizard.create'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('blog.wizard.create')); ?>"><?php echo e(localize('Generate Full Article')); ?></a>
                            </li>
                        </ul>
                    </div>
                </li>
            <?php endif; ?>
        <?php endif; ?>


        <?php if(getSetting('enable_built_in_templates') != '0'): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('templates')): ?>
                <li
                    class="side-nav-item nav-item <?php echo e(areActiveRoutes(['templates.index', 'templates.edit', 'templates.show'], 'tt-menu-item-active')); ?>">
                    <a href="<?php echo e(route('templates.index')); ?>" class="side-nav-link">
                        <span class="tt-nav-link-icon"> <i data-feather="layers"></i></span>
                        <span class="tt-nav-link-text"><?php echo e(localize('Templates')); ?></span>
                    </a>
                </li>
            <?php endif; ?>
        <?php endif; ?>

        <?php if(getSetting('enable_custom_templates') != '0'): ?>
            <!-- custom tempaltes -->
            <?php
                $customTemplateActiveRoutes = ['custom.templateCategories.index', 'custom.templateCategories.edit', 'custom.templates.index', 'custom.templates.create', 'custom.templates.edit', 'custom.templates.show'];
            ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['custom_template_categories', 'custom_templates'])): ?>
                <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($customTemplateActiveRoutes, 'tt-menu-item-active')); ?>">
                    <a data-bs-toggle="collapse" href="#customTemplates"
                        aria-expanded="<?php echo e(areActiveRoutes($customTemplateActiveRoutes, 'true')); ?>"
                        aria-controls="customTemplates" class="side-nav-link tt-menu-toggle">
                        <span class="tt-nav-link-icon"><i data-feather="codepen"></i></span>
                        <span class="tt-nav-link-text"><?php echo e(localize('Custom Templates')); ?></span>
                    </a>
                    <div class="collapse <?php echo e(areActiveRoutes($customTemplateActiveRoutes, 'show')); ?>" id="customTemplates">
                        <ul class="side-nav-second-level">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('custom_template_categories')): ?>
                                <li
                                    class="<?php echo e(areActiveRoutes(['custom.templateCategories.index', 'custom.templateCategories.edit'], 'tt-menu-item-active')); ?>">
                                    <a href="<?php echo e(route('custom.templateCategories.index')); ?>"><?php echo e(localize('Categories')); ?></a>
                                </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('custom_templates')): ?>
                                <li
                                    class="<?php echo e(areActiveRoutes(['custom.templates.index', 'custom.templates.create', 'custom.templates.edit', 'custom.templates.show'], 'tt-menu-item-active')); ?>">
                                    <a href="<?php echo e(route('custom.templates.index')); ?>"><?php echo e(localize('All Templates')); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li>
            <?php endif; ?>
        <?php endif; ?>

        <?php if(getSetting('enable_ai_images') != '0'): ?>
            <?php
                $imagesActiveRoutes = ['images.index', 'sdImages.index'];
            ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['dall_e_2', 'dall_e_3', 'stable_diffusion'])): ?>
                <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($imagesActiveRoutes, 'tt-menu-item-active')); ?>">
                    <a data-bs-toggle="collapse" href="#generateImages"
                        aria-expanded="<?php echo e(areActiveRoutes($imagesActiveRoutes, 'true')); ?>" aria-controls="generateImages"
                        class="side-nav-link tt-menu-toggle">
                        <span class="tt-nav-link-icon"><i data-feather="image"></i></span>
                        <span class="tt-nav-link-text"><?php echo e(localize('AI Images')); ?></span>
                    </a>
                    <div class="collapse <?php echo e(areActiveRoutes($imagesActiveRoutes, 'show')); ?>" id="generateImages">
                        <ul class="side-nav-second-level">

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dall_e_2')): ?>
                                <li class="<?php echo e(areActiveRoutes(['images.index'], 'tt-menu-item-active')); ?>">
                                    <a href="<?php echo e(route('images.index')); ?>"><?php echo e(localize('Dall-E 2')); ?></a>
                                </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dall_e_3')): ?>
                                <li class="<?php echo e(areActiveRoutes(['images.dall-e-3'], 'tt-menu-item-active')); ?>">
                                    <a href="<?php echo e(route('images.dall-e-3')); ?>"><?php echo e(localize('Dall-E 3')); ?></a>
                                </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('stable_diffusion')): ?>
                                <li class="<?php echo e(areActiveRoutes(['sdImages.index'], 'tt-menu-item-active')); ?>">
                                    <a href="<?php echo e(route('sdImages.index')); ?>"><?php echo e(localize('Stable Diffusion')); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </li>
            <?php endif; ?>
        <?php endif; ?>





        <?php if(getSetting('enable_text_to_speech') != '0'): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('text_to_speech')): ?>
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('t2s.index')); ?>" class="side-nav-link">
                        <span class="tt-nav-link-icon"> <i data-feather="volume-2"></i></span>
                        <span class="tt-nav-link-text"><?php echo e(localize('Text To Speech')); ?></span>
                    </a>
                </li>
            <?php endif; ?>
        <?php endif; ?>
        <?php if(getSetting('enable_speech_to_text') != '0'): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('speech_to_text')): ?>
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('s2t.index')); ?>" class="side-nav-link">
                        <span class="tt-nav-link-icon"> <i data-feather="mic"></i></span>
                        <span class="tt-nav-link-text"><?php echo e(localize('Speech to Text')); ?></span>
                    </a>
                </li>
            <?php endif; ?>
        <?php endif; ?>
        <?php if(getSetting('enable_eleven_labs') != '0'): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('text_to_speech_eleven_labs')): ?>
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('t2s.index.eleven-labs')); ?>" class="side-nav-link">
                        <span class="tt-nav-link-icon"> <i data-feather="volume-2"></i></span>
                        <span class="tt-nav-link-text"><?php echo e(localize('Eleven Labs')); ?></span>
                    </a>
                </li>
            <?php endif; ?>
        <?php endif; ?>



        <?php if(getSetting('enable_ai_code') != '0'): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('generate_code')): ?>
                <li class="side-nav-item nav-item">
                    <a href="<?php echo e(route('codes.index')); ?>" class="side-nav-link">
                        <span class="tt-nav-link-icon"> <i data-feather="code"></i></span>
                        <span class="tt-nav-link-text"><?php echo e(localize('AI Code')); ?></span>
                    </a>
                </li>
            <?php endif; ?>
        <?php endif; ?>





        <?php if(getSetting('enable_built_in_templates') != '0'): ?>
            <!-- popular templates -->
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['popular_templates', 'view', 'delete'])): ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('popular_templates')): ?>
                    <li class="side-nav-item nav-item">
                        <a href="<?php echo e(route('templates.popular')); ?>" class="side-nav-link">
                            <span class="tt-nav-link-icon"><i data-feather="award"></i></span>
                            <span class="tt-nav-link-text"><?php echo e(localize('Popular Templates')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('favorites_templates')): ?>
                    <!-- favorite templates -->
                    <li class="side-nav-item nav-item">
                        <a href="<?php echo e(route('templates.favorites')); ?>" class="side-nav-link">
                            <span class="tt-nav-link-icon"><i data-feather="heart"></i></span>
                            <span class="tt-nav-link-text"><?php echo e(localize('Favorite Templates')); ?></span>
                        </a>
                    </li>
                <?php endif; ?>

            <?php endif; ?>
        <?php endif; ?>

    <?php endif; ?>



    <?php
        $reportsActiveRoutes = ['admin.reports.words', 'admin.reports.codes', 'admin.reports.images', 'admin.reports.s2t', 'admin.reports.mostUsed', 'admin.reports.subscriptions'];
    ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['words_report', 'codes_report', 'images_report', 's2t_report', 'most_used_templates',
        'subscriptions_reports'])): ?>
        <!-- Report -->
        <li class="side-nav-title side-nav-item nav-item mt-3">
            <span class="tt-nav-title-text text-muted"><?php echo e(localize('Reports')); ?></span>
        </li>
        <!-- Report -->
        <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($reportsActiveRoutes, 'tt-menu-item-active')); ?>">
            <a data-bs-toggle="collapse" href="#reports"
                aria-expanded="<?php echo e(areActiveRoutes($reportsActiveRoutes, 'true')); ?>" aria-controls="reports"
                class="side-nav-link tt-menu-toggle">
                <span class="tt-nav-link-icon"><i data-feather="bar-chart"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('Reports')); ?></span>
            </a>
            <div class="collapse <?php echo e(areActiveRoutes($reportsActiveRoutes, 'show')); ?>" id="reports">
                <ul class="side-nav-second-level">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('words_report')): ?>
                        <li class="<?php echo e(areActiveRoutes(['admin.reports.words'], 'tt-menu-item-active')); ?>">
                            <a href="<?php echo e(route('admin.reports.words')); ?>"><?php echo e(localize('Words Report')); ?></a>
                        </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('codes_report')): ?>
                        <li class="<?php echo e(areActiveRoutes(['admin.reports.codes'], 'tt-menu-item-active')); ?>">
                            <a href="<?php echo e(route('admin.reports.codes')); ?>"><?php echo e(localize('Codes Report')); ?></a>
                        </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('images_report')): ?>
                        <li class="<?php echo e(areActiveRoutes(['admin.reports.images'], 'tt-menu-item-active')); ?>">
                            <a href="<?php echo e(route('admin.reports.images')); ?>"><?php echo e(localize('Images Report')); ?></a>
                        </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('s2t_report')): ?>
                        <li class="<?php echo e(areActiveRoutes(['admin.reports.s2t'], 'tt-menu-item-active')); ?>">
                            <a href="<?php echo e(route('admin.reports.s2t')); ?>"><?php echo e(localize('Speech to Texts')); ?></a>
                        </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('most_used_templates')): ?>
                        <li class="<?php echo e(areActiveRoutes(['admin.reports.mostUsed'], 'tt-menu-item-active')); ?>">
                            <a href="<?php echo e(route('admin.reports.mostUsed')); ?>"><?php echo e(localize('Most Used Templates')); ?></a>
                        </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('subscriptions_reports')): ?>
                        <li class="<?php echo e(areActiveRoutes(['admin.reports.subscriptions'], 'tt-menu-item-active')); ?>">
                            <a
                                href="<?php echo e(route('admin.reports.subscriptions')); ?>"><?php echo e(localize('Subscriptions Reports')); ?></a>
                        </li>
                    <?php endif; ?>

                </ul>
            </div>
        </li>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['customers', 'all_staffs', 'add_staffs'])): ?>
        <!-- Users -->
        <li class="side-nav-title side-nav-item nav-item mt-3">
            <span class="tt-nav-title-text text-muted"><?php echo e(localize('Manage Users')); ?></span>
        </li>
    <?php endif; ?>
    <!-- customers -->
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customers')): ?>
        <li
            class="side-nav-item nav-item  <?php echo e(areActiveRoutes(['admin.customers.index', 'admin.customers.create', 'admin.customers.create', 'admin.customers.assignPackage'], 'tt-menu-item-active')); ?>">
            <a href="<?php echo e(route('admin.customers.index')); ?>" class="side-nav-link">
                <span class="tt-nav-link-icon"> <i data-feather="users"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('Customers')); ?></span>
            </a>
        </li>
    <?php endif; ?>

    <!-- staffs -->
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['all_staffs', 'add_staffs'])): ?>
        <li
            class="side-nav-item nav-item <?php echo e(areActiveRoutes(['admin.staffs.index', 'admin.staffs.create', 'admin.staffs.edit'], 'tt-menu-item-active')); ?>">
            <a href="<?php echo e(route('admin.staffs.index')); ?>" class="side-nav-link">
                <span class="tt-nav-link-icon"> <i data-feather="user-check"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('Employee Staffs')); ?></span>
            </a>
        </li>
    <?php endif; ?>


    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['contact_us_messages', 'support.index'])): ?>
        <!-- support -->
        <li class="side-nav-title side-nav-item nav-item mt-3">
            <span class="tt-nav-title-text text-muted"><?php echo e(localize('Support')); ?></span>
        </li>

        <!-- conatact us -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contact_us_messages')): ?>
            <li class="side-nav-item nav-item <?php echo e(areActiveRoutes(['admin.queries.index'], 'tt-menu-item-active')); ?>">
                <a href="<?php echo e(route('admin.queries.index')); ?>"
                    class="side-nav-link <?php echo e(areActiveRoutes(['admin.queries.index'])); ?>">
                    <span class="tt-nav-link-icon"><i data-feather="headphones"></i></span>
                    <span class="tt-nav-link-text">
                        <span><?php echo e(localize('Queries')); ?></span>

                        <?php
                            $newMsgCount = \App\Models\ContactUsMessage::where('is_seen', 0)->count();
                        ?>

                        <?php if($newMsgCount > 0): ?>
                            <small class="badge bg-danger"><?php echo e(localize('New')); ?></small>
                        <?php endif; ?>
                    </span>
                </a>
            </li>
        <?php endif; ?>
        <?php if(isModuleActive('Support')): ?>
            <?php echo $__env->make('support::sidebar.support_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['blogs', 'blog_categories', 'admin.tags.index', 'admin.tags.edit', 'admin.blogs.index',
        'admin.blogs.create', 'admin.blogs.edit', 'admin.blogCategories.index', 'admin.blogCategories.edit',
        'admin.pages.index', 'admin.pages.create', 'admin.pages.edit', 'admin.faqs.index', 'admin.faqs.edit',
        'media_manager'])): ?>
        <!-- Contents -->
        <li class="side-nav-title side-nav-item nav-item mt-3">
            <span class="tt-nav-title-text text-muted"><?php echo e(localize('Manage Contents')); ?></span>
        </li>
    <?php endif; ?>


    <!-- tags -->
    <?php
        $tagsActiveRoutes = ['admin.tags.index', 'admin.tags.edit'];
    ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tags')): ?>
        <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($tagsActiveRoutes, 'tt-menu-item-active')); ?>">
            <a href="<?php echo e(route('admin.tags.index')); ?>" class="side-nav-link">
                <span class="tt-nav-link-icon"> <i data-feather="tag"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('Tags')); ?></span>
            </a>
        </li>
    <?php endif; ?>

    <!-- Blog Systems -->
    <?php
        $blogActiveRoutes = ['admin.blogs.index', 'admin.blogs.create', 'admin.blogs.edit', 'admin.blogCategories.index', 'admin.blogCategories.edit'];
    ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['blogs', 'blog_categories'])): ?>
        <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($blogActiveRoutes, 'tt-menu-item-active')); ?>">
            <a data-bs-toggle="collapse" href="#blogSystem"
                aria-expanded="<?php echo e(areActiveRoutes($blogActiveRoutes, 'true')); ?>" aria-controls="blogSystem"
                class="side-nav-link tt-menu-toggle">
                <span class="tt-nav-link-icon"><i data-feather="file-text"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('Blogs')); ?></span>
            </a>
            <div class="collapse <?php echo e(areActiveRoutes($blogActiveRoutes, 'show')); ?>" id="blogSystem">
                <ul class="side-nav-second-level">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('blogs')): ?>
                        <li
                            class="<?php echo e(areActiveRoutes(['admin.blogs.index', 'admin.blogs.create', 'admin.blogs.edit'], 'tt-menu-item-active')); ?>">
                            <a href="<?php echo e(route('admin.blogs.index')); ?>"
                                class="<?php echo e(areActiveRoutes(['admin.blogs.index', 'admin.blogs.create', 'admin.blogs.edit'])); ?>"><?php echo e(localize('All Blogs')); ?></a>
                        </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('blog_categories')): ?>
                        <li
                            class="<?php echo e(areActiveRoutes(['admin.blogCategories.index', 'admin.blogCategories.edit'], 'tt-menu-item-active')); ?>">
                            <a href="<?php echo e(route('admin.blogCategories.index')); ?>"><?php echo e(localize('Categories')); ?></a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </li>
    <?php endif; ?>


    <!-- pages -->
    <?php
        $pagesActiveRoutes = ['admin.pages.index', 'admin.pages.create', 'admin.pages.edit'];
    ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pages')): ?>
        <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($pagesActiveRoutes, 'tt-menu-item-active')); ?>">
            <a href="<?php echo e(route('admin.pages.index')); ?>" class="side-nav-link">
                <span class="tt-nav-link-icon"> <i data-feather="copy"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('Pages')); ?></span>
            </a>
        </li>
    <?php endif; ?>

    <!-- faq -->
    <?php
        $faqsActiveRoutes = ['admin.faqs.index', 'admin.faqs.edit'];
    ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('faqs')): ?>
        <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($faqsActiveRoutes, 'tt-menu-item-active')); ?>">
            <a href="<?php echo e(route('admin.faqs.index')); ?>" class="side-nav-link">
                <span class="tt-nav-link-icon"> <i data-feather="help-circle"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('All FAQs')); ?></span>
            </a>
        </li>
    <?php endif; ?>


    <!-- media manager -->
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('media_manager')): ?>
        <li class="side-nav-item">
            <a href="<?php echo e(route('admin.mediaManager.index')); ?>" class="side-nav-link">
                <span class="tt-nav-link-icon"> <i data-feather="folder"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('Media Manager')); ?></span>
            </a>
        </li>
    <?php endif; ?>



    <!-- newsletter -->
    <?php
        $newsletterActiveRoutes = ['admin.newsletters.index', 'admin.subscribers.index'];
    ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['newsletters', 'subscribers'])): ?>
        <!-- Promotions -->
        <li class="side-nav-title side-nav-item nav-item mt-3">
            <span class="tt-nav-title-text text-muted"><?php echo e(localize('Manage Promotions')); ?></span>
        </li>
        <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($newsletterActiveRoutes, 'tt-menu-item-active')); ?>">
            <a data-bs-toggle="collapse" href="#newsletter"
                aria-expanded="<?php echo e(areActiveRoutes($newsletterActiveRoutes, 'true')); ?>" aria-controls="newsletter"
                class="side-nav-link tt-menu-toggle">
                <span class="tt-nav-link-icon"><i data-feather="book-open"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('Newsletters')); ?></span>
            </a>
            <div class="collapse <?php echo e(areActiveRoutes($newsletterActiveRoutes, 'show')); ?>" id="newsletter">
                <ul class="side-nav-second-level">

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('newsletters')): ?>
                        <li class="<?php echo e(areActiveRoutes(['admin.newsletters.index'], 'tt-menu-item-active')); ?>">
                            <a href="<?php echo e(route('admin.newsletters.index')); ?>"
                                class="<?php echo e(areActiveRoutes(['admin.newsletters.index'])); ?>"><?php echo e(localize('Bulk Emails')); ?></a>
                        </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('subscribers')): ?>
                        <li class="<?php echo e(areActiveRoutes(['admin.subscribers.index'], 'tt-menu-item-active')); ?>">
                            <a href="<?php echo e(route('admin.subscribers.index')); ?>"
                                lass="<?php echo e(areActiveRoutes(['admin.newsletters.index'])); ?>"><?php echo e(localize('Subscribers')); ?></a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </li>
    <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['open_ai', 'fine_tune', 'voice_settings', 'homepage', 'about_us_page', 'header', 'footer',
        'roles_and_permissions', 'smtp_settings', 'auth_settings', 'otp_settings', 'general_settings', 'payment_settings',
        'social_login_settings', 'currency_settings', 'language_settings', 'admin.offline-payment.index'])): ?>
        <!-- Settings -->
        <li class="side-nav-title side-nav-item nav-item mt-3">
            <span class="tt-nav-title-text text-muted"><?php echo e(localize('Manage Settings')); ?></span>
        </li>


        <!-- open AI -->
        <?php
            $openAiActiveRoutes = ['admin.settings.openAi', 'admin.multiOpenAi.index', 'admin.multiOpenAi.create', 'admin.multiOpenAi.edit'];
        ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('open_ai')): ?>
            <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($openAiActiveRoutes, 'tt-menu-item-active')); ?>">
                <a href="<?php echo e(route('admin.settings.openAi')); ?>" class="side-nav-link">
                    <span class="tt-nav-link-icon"><i data-feather="aperture"></i></span>
                    <span class="tt-nav-link-text"><?php echo e(localize('AI Settings')); ?></span>
                </a>
            </li>
        <?php endif; ?>
        
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('fine_tune')): ?>
            <li class="side-nav-item nav-item">
                <a href="<?php echo e(route('fine-tunes.index')); ?>" class="side-nav-link">
                    <span class="tt-nav-link-icon"> <i data-feather="file-text"></i></span>
                    <span class="tt-nav-link-text"><?php echo e(localize('Fine Tuning')); ?></span>
                </a>
            </li>
        <?php endif; ?>
        <?php if(auth()->user()->user_type == 'admin'): ?>
            <li class="side-nav-item nav-item <?php echo e(areActiveRoutes(['admin.about-update'], 'tt-menu-item-active')); ?>">
                <a href="<?php echo e(route('admin.about-update')); ?>" class="side-nav-link">
                    <span class="tt-nav-link-icon"><i data-feather="refresh-cw"></i></span>
                    <span class="tt-nav-link-text"><?php echo e(localize('Update')); ?>

                        <?php if(session()->get('latestVersion')): ?>
                            <?php if(session()->get('latestVersion') > currentVersion()): ?>
                                <small class="badge bg-danger"><?php echo e(localize('New')); ?></small>
                            <?php endif; ?>
                        <?php endif; ?>
                    </span>
                </a>

            </li>
        <?php endif; ?>
        <?php
            $googlettsActiveRoutes = ['admin.settings.voice-settings'];
        ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('voice_settings')): ?>
            <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($googlettsActiveRoutes, 'tt-menu-item-active')); ?>">
                <a href="<?php echo e(route('admin.settings.voice-settings')); ?>" class="side-nav-link">
                    <span class="tt-nav-link-icon"><i data-feather="volume-2"></i></span>
                    <span class="tt-nav-link-text"><?php echo e(localize('Voice Settings')); ?></span>
                </a>
            </li>
        <?php endif; ?>

        <!-- Appearance -->
        <?php
            $appearanceActiveRoutes = ['admin.appearance.header', 'admin.appearance.aboutUs', 'admin.appearance.homepage.hero', 'admin.appearance.homepage.trustedBy', 'admin.appearance.homepage.howItWorks', 'admin.appearance.homepage.featureImages', 'admin.appearance.homepage.clientFeedback', 'admin.appearance.homepage.editClientFeedback', 'admin.appearance.homepage.cta'];

            $homepageActiveRoutes = ['admin.appearance.homepage.hero', 'admin.appearance.homepage.trustedBy', 'admin.appearance.homepage.howItWorks', 'admin.appearance.homepage.featureImages', 'admin.appearance.homepage.clientFeedback', 'admin.appearance.homepage.editClientFeedback', 'admin.appearance.homepage.cta'];
        ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['homepage', 'about_us_page', 'header', 'footer'])): ?>
            <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($appearanceActiveRoutes, 'tt-menu-item-active')); ?>">
                <a data-bs-toggle="collapse" href="#Appearance"
                    aria-expanded="<?php echo e(areActiveRoutes($appearanceActiveRoutes, 'true')); ?>" aria-controls="Appearance"
                    class="side-nav-link tt-menu-toggle">
                    <span class="tt-nav-link-icon"><i data-feather="layout"></i></span>
                    <span class="tt-nav-link-text"><?php echo e(localize('Appearance')); ?></span>
                </a>
                <div class="collapse <?php echo e(areActiveRoutes($appearanceActiveRoutes, 'show')); ?>" id="Appearance">
                    <ul class="side-nav-second-level">

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('homepage')): ?>
                            <li class="<?php echo e(areActiveRoutes($homepageActiveRoutes, 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('admin.appearance.homepage.hero')); ?>"
                                    class="<?php echo e(areActiveRoutes($homepageActiveRoutes)); ?>"><?php echo e(localize('Homepage')); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('about_us_page')): ?>
                            <li class="">
                                <a href="<?php echo e(route('admin.appearance.aboutUs')); ?>"
                                    class="<?php echo e(areActiveRoutes($homepageActiveRoutes)); ?>"><?php echo e(localize('About Us')); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('header')): ?>
                            <li class="<?php echo e(areActiveRoutes(['admin.appearance.header'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('admin.appearance.header')); ?>"
                                    class="<?php echo e(areActiveRoutes(['admin.appearance.header'])); ?>"><?php echo e(localize('Header')); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('footer')): ?>
                            <li class="<?php echo e(areActiveRoutes(['admin.appearance.footer'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('admin.appearance.footer')); ?>"
                                    class="<?php echo e(areActiveRoutes(['admin.appearance.footer'])); ?>"><?php echo e(localize('Footer')); ?></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
        <?php endif; ?>


        <!-- Roles & Permission -->
        <?php
            $rolesActiveRoutes = ['admin.roles.index', 'admin.roles.create', 'admin.roles.edit'];
        ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles_and_permissions')): ?>
            <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($rolesActiveRoutes, 'tt-menu-item-active')); ?>">
                <a href="<?php echo e(route('admin.roles.index')); ?>" class="side-nav-link">
                    <span class="tt-nav-link-icon"><i data-feather="unlock"></i></span>
                    <span class="tt-nav-link-text"><?php echo e(localize('Roles & Permissions')); ?></span>
                </a>
            </li>
        <?php endif; ?>


        <!-- system settings -->
        <?php
            $settingsActiveRoutes = ['admin.generalSettings', 'admin.orderSettings', 'admin.timeslot.edit', 'admin.languages.index', 'admin.languages.edit', 'admin.currencies.index', 'admin.currencies.edit', 'admin.languages.localizations', 'admin.smtpSettings.index', 'admin.offline-payment.index', 'admin.cronJobList'];
        ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['smtp_settings', 'auth_settings', 'otp_settings', 'general_settings', 'payment_settings',
            'social_login_settings', 'currency_settings', 'language_settings', 'admin.offline-payment.index',
            'admin.cronJobList', 'email_template', 'cron_job', 'google_ads', 'storage_management', 'pwa_settings',
            'offline_payment'])): ?>

            <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($settingsActiveRoutes, 'tt-menu-item-active')); ?>">
                <a data-bs-toggle="collapse" href="#systemSetting"
                    aria-expanded="<?php echo e(areActiveRoutes($settingsActiveRoutes, 'true')); ?>" aria-controls="systemSetting"
                    class="side-nav-link tt-menu-toggle">
                    <span class="tt-nav-link-icon"><i data-feather="settings"></i></span>
                    <span class="tt-nav-link-text"><?php echo e(localize('System Settings')); ?></span>
                </a>
                <div class="collapse <?php echo e(areActiveRoutes($settingsActiveRoutes, 'show')); ?>" id="systemSetting">
                    <ul class="side-nav-second-level">

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('general_settings')): ?>
                            <li class="<?php echo e(areActiveRoutes(['admin.generalSettings'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('admin.generalSettings')); ?>"
                                    class="<?php echo e(areActiveRoutes(['admin.generalSettings'])); ?>"><?php echo e(localize('General Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('email_template')): ?>
                            <li class="<?php echo e(areActiveRoutes(['admin.email-template.index'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('admin.email-template.index')); ?>"
                                    class="<?php echo e(areActiveRoutes(['admin.email-template.index'])); ?>"><?php echo e(localize('Email Template')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cron_job')): ?>
                            <li class="<?php echo e(areActiveRoutes(['admin.cronJobList'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('admin.cronJobList')); ?>"
                                    class="<?php echo e(areActiveRoutes(['admin.cronJobList'])); ?>"><?php echo e(localize('Cron Job')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('google_ads')): ?>
                            <li class="<?php echo e(areActiveRoutes(['admin.settings.adsense'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('admin.settings.adsense')); ?>"
                                    class="<?php echo e(areActiveRoutes(['admin.settings.adsense'])); ?>"><?php echo e(localize('Google Ads')); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('storage_management')): ?>
                            <li class="<?php echo e(areActiveRoutes(['admin.storage-management.index'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('admin.storage-management.index')); ?>"
                                    class="<?php echo e(areActiveRoutes(['admin.storage-management.index'])); ?>"><?php echo e(localize('Storage Manager')); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('auth_settings')): ?>
                            <li class="<?php echo e(areActiveRoutes(['admin.settings.authSettings'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('admin.settings.authSettings')); ?>"
                                    class="<?php echo e(areActiveRoutes(['admin.settings.authSettings'])); ?>"><?php echo e(localize('Auth Settings')); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('otp_settings')): ?>
                            <li class="<?php echo e(areActiveRoutes(['admin.settings.otpSettings'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('admin.settings.otpSettings')); ?>"
                                    class="<?php echo e(areActiveRoutes(['admin.settings.otpSettings'])); ?>"><?php echo e(localize('OTP Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('smtp_settings')): ?>
                            <li class="<?php echo e(areActiveRoutes(['admin.smtpSettings.index'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('admin.smtpSettings.index')); ?>"
                                    class="<?php echo e(areActiveRoutes(['admin.smtpSettings.index'])); ?>"><?php echo e(localize('SMTP Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pwa_settings')): ?>
                            <li class="<?php echo e(areActiveRoutes(['admin.settings.pwa'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('admin.settings.pwa')); ?>"
                                    class="<?php echo e(areActiveRoutes(['admin.settings.pwa'])); ?>"><?php echo e(localize('PWA Settings')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('offline_payment')): ?>
                            <li class="<?php echo e(areActiveRoutes(['admin.offline-payment.index'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('admin.offline-payment.index')); ?>"
                                    class="<?php echo e(areActiveRoutes(['admin.offline-payment.index'])); ?>"><?php echo e(localize('Offline Payment')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payment_settings')): ?>
                            <li class="<?php echo e(areActiveRoutes(['admin.settings.paymentMethods'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('admin.settings.paymentMethods')); ?>"
                                    class="<?php echo e(areActiveRoutes(['admin.settings.paymentMethods'])); ?>"><?php echo e(localize('Payment Methods')); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('social_login_settings')): ?>
                            <li class="<?php echo e(areActiveRoutes(['admin.settings.socialLogin'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('admin.settings.socialLogin')); ?>"
                                    class="<?php echo e(areActiveRoutes(['admin.settings.socialLogin'])); ?>"><?php echo e(localize('Social Media Login')); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('language_settings')): ?>
                            <li
                                class="<?php echo e(areActiveRoutes(
                                    ['admin.languages.index', 'admin.languages.edit', 'admin.languages.localizations'],
                                    'tt-menu-item-active',
                                )); ?>">
                                <a href="<?php echo e(route('admin.languages.index')); ?>"
                                    class="<?php echo e(areActiveRoutes(['admin.languages.index', 'admin.languages.edit', 'admin.languages.localizations'])); ?>"><?php echo e(localize('Multilingual Settings')); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('currency_settings')): ?>
                            <li
                                class="<?php echo e(areActiveRoutes(
                                    ['admin.currencies.index', 'admin.currencies.edit', 'admin.currencies.localizations'],
                                    'tt-menu-item-active',
                                )); ?>">
                                <a href="<?php echo e(route('admin.currencies.index')); ?>"
                                    class="<?php echo e(areActiveRoutes(['admin.currencies.index', 'admin.currencies.edit', 'admin.currencies.localizations'])); ?>"><?php echo e(localize('Multi Currency Settings')); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if(isAdmin()): ?>
                            <li class="<?php echo e(areActiveRoutes(['admin.utilities'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('admin.utilities')); ?>"
                                    class="<?php echo e(areActiveRoutes(['admin.utilities'])); ?>">
                                    <?php echo e(localize('Utilities')); ?>

                                </a>
                            </li>

                            <li class="<?php echo e(areActiveRoutes(['system.file-permission'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('system.file-permission')); ?>"
                                    class="<?php echo e(areActiveRoutes(['system.file-permission'])); ?>"><?php echo e(localize('File Permission')); ?></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
        <?php endif; ?>
    <?php endif; ?>
</ul>
<?php /**PATH E:\xampp\htdocs\ai\pinterai\resources\views/backend/inc/sidebarMenus.blade.php ENDPATH**/ ?>